import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteInstanceEventWindowRequest, DeleteInstanceEventWindowResult } from "../models/models_2";
import { deserializeAws_ec2DeleteInstanceEventWindowCommand, serializeAws_ec2DeleteInstanceEventWindowCommand, } from "../protocols/Aws_ec2";
var DeleteInstanceEventWindowCommand = (function (_super) {
    __extends(DeleteInstanceEventWindowCommand, _super);
    function DeleteInstanceEventWindowCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteInstanceEventWindowCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteInstanceEventWindowCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteInstanceEventWindowRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteInstanceEventWindowResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteInstanceEventWindowCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteInstanceEventWindowCommand(input, context);
    };
    DeleteInstanceEventWindowCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteInstanceEventWindowCommand(output, context);
    };
    return DeleteInstanceEventWindowCommand;
}($Command));
export { DeleteInstanceEventWindowCommand };
