import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteFleetsRequest, DeleteFleetsResult } from "../models/models_2";
import { deserializeAws_ec2DeleteFleetsCommand, serializeAws_ec2DeleteFleetsCommand } from "../protocols/Aws_ec2";
var DeleteFleetsCommand = (function (_super) {
    __extends(DeleteFleetsCommand, _super);
    function DeleteFleetsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteFleetsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteFleetsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteFleetsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteFleetsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteFleetsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteFleetsCommand(input, context);
    };
    DeleteFleetsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteFleetsCommand(output, context);
    };
    return DeleteFleetsCommand;
}($Command));
export { DeleteFleetsCommand };
