import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteCustomerGatewayRequest } from "../models/models_2";
import { deserializeAws_ec2DeleteCustomerGatewayCommand, serializeAws_ec2DeleteCustomerGatewayCommand, } from "../protocols/Aws_ec2";
var DeleteCustomerGatewayCommand = (function (_super) {
    __extends(DeleteCustomerGatewayCommand, _super);
    function DeleteCustomerGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteCustomerGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteCustomerGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteCustomerGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteCustomerGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteCustomerGatewayCommand(input, context);
    };
    DeleteCustomerGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteCustomerGatewayCommand(output, context);
    };
    return DeleteCustomerGatewayCommand;
}($Command));
export { DeleteCustomerGatewayCommand };
