import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteClientVpnEndpointRequest, DeleteClientVpnEndpointResult } from "../models/models_2";
import { deserializeAws_ec2DeleteClientVpnEndpointCommand, serializeAws_ec2DeleteClientVpnEndpointCommand, } from "../protocols/Aws_ec2";
var DeleteClientVpnEndpointCommand = (function (_super) {
    __extends(DeleteClientVpnEndpointCommand, _super);
    function DeleteClientVpnEndpointCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteClientVpnEndpointCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DeleteClientVpnEndpointCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteClientVpnEndpointRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteClientVpnEndpointResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteClientVpnEndpointCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DeleteClientVpnEndpointCommand(input, context);
    };
    DeleteClientVpnEndpointCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DeleteClientVpnEndpointCommand(output, context);
    };
    return DeleteClientVpnEndpointCommand;
}($Command));
export { DeleteClientVpnEndpointCommand };
