import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateVpnConnectionRouteRequest } from "../models/models_2";
import { deserializeAws_ec2CreateVpnConnectionRouteCommand, serializeAws_ec2CreateVpnConnectionRouteCommand, } from "../protocols/Aws_ec2";
var CreateVpnConnectionRouteCommand = (function (_super) {
    __extends(CreateVpnConnectionRouteCommand, _super);
    function CreateVpnConnectionRouteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateVpnConnectionRouteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateVpnConnectionRouteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateVpnConnectionRouteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateVpnConnectionRouteCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateVpnConnectionRouteCommand(input, context);
    };
    CreateVpnConnectionRouteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateVpnConnectionRouteCommand(output, context);
    };
    return CreateVpnConnectionRouteCommand;
}($Command));
export { CreateVpnConnectionRouteCommand };
