import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateVpcRequest, CreateVpcResult } from "../models/models_2";
import { deserializeAws_ec2CreateVpcCommand, serializeAws_ec2CreateVpcCommand } from "../protocols/Aws_ec2";
var CreateVpcCommand = (function (_super) {
    __extends(CreateVpcCommand, _super);
    function CreateVpcCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateVpcCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateVpcCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateVpcRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateVpcResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateVpcCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateVpcCommand(input, context);
    };
    CreateVpcCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateVpcCommand(output, context);
    };
    return CreateVpcCommand;
}($Command));
export { CreateVpcCommand };
