import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateVolumeRequest, Volume } from "../models/models_2";
import { deserializeAws_ec2CreateVolumeCommand, serializeAws_ec2CreateVolumeCommand } from "../protocols/Aws_ec2";
var CreateVolumeCommand = (function (_super) {
    __extends(CreateVolumeCommand, _super);
    function CreateVolumeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateVolumeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateVolumeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateVolumeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: Volume.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateVolumeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateVolumeCommand(input, context);
    };
    CreateVolumeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateVolumeCommand(output, context);
    };
    return CreateVolumeCommand;
}($Command));
export { CreateVolumeCommand };
