import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateTransitGatewayMulticastDomainRequest, CreateTransitGatewayMulticastDomainResult, } from "../models/models_2";
import { deserializeAws_ec2CreateTransitGatewayMulticastDomainCommand, serializeAws_ec2CreateTransitGatewayMulticastDomainCommand, } from "../protocols/Aws_ec2";
var CreateTransitGatewayMulticastDomainCommand = (function (_super) {
    __extends(CreateTransitGatewayMulticastDomainCommand, _super);
    function CreateTransitGatewayMulticastDomainCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateTransitGatewayMulticastDomainCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateTransitGatewayMulticastDomainCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateTransitGatewayMulticastDomainRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateTransitGatewayMulticastDomainResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateTransitGatewayMulticastDomainCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateTransitGatewayMulticastDomainCommand(input, context);
    };
    CreateTransitGatewayMulticastDomainCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateTransitGatewayMulticastDomainCommand(output, context);
    };
    return CreateTransitGatewayMulticastDomainCommand;
}($Command));
export { CreateTransitGatewayMulticastDomainCommand };
