import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateTrafficMirrorTargetRequest, CreateTrafficMirrorTargetResult } from "../models/models_1";
import { deserializeAws_ec2CreateTrafficMirrorTargetCommand, serializeAws_ec2CreateTrafficMirrorTargetCommand, } from "../protocols/Aws_ec2";
var CreateTrafficMirrorTargetCommand = (function (_super) {
    __extends(CreateTrafficMirrorTargetCommand, _super);
    function CreateTrafficMirrorTargetCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateTrafficMirrorTargetCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateTrafficMirrorTargetCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateTrafficMirrorTargetRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateTrafficMirrorTargetResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateTrafficMirrorTargetCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateTrafficMirrorTargetCommand(input, context);
    };
    CreateTrafficMirrorTargetCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateTrafficMirrorTargetCommand(output, context);
    };
    return CreateTrafficMirrorTargetCommand;
}($Command));
export { CreateTrafficMirrorTargetCommand };
