import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateTrafficMirrorSessionRequest, CreateTrafficMirrorSessionResult } from "../models/models_1";
import { deserializeAws_ec2CreateTrafficMirrorSessionCommand, serializeAws_ec2CreateTrafficMirrorSessionCommand, } from "../protocols/Aws_ec2";
var CreateTrafficMirrorSessionCommand = (function (_super) {
    __extends(CreateTrafficMirrorSessionCommand, _super);
    function CreateTrafficMirrorSessionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateTrafficMirrorSessionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateTrafficMirrorSessionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateTrafficMirrorSessionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateTrafficMirrorSessionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateTrafficMirrorSessionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateTrafficMirrorSessionCommand(input, context);
    };
    CreateTrafficMirrorSessionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateTrafficMirrorSessionCommand(output, context);
    };
    return CreateTrafficMirrorSessionCommand;
}($Command));
export { CreateTrafficMirrorSessionCommand };
