import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateStoreImageTaskRequest, CreateStoreImageTaskResult } from "../models/models_1";
import { deserializeAws_ec2CreateStoreImageTaskCommand, serializeAws_ec2CreateStoreImageTaskCommand, } from "../protocols/Aws_ec2";
var CreateStoreImageTaskCommand = (function (_super) {
    __extends(CreateStoreImageTaskCommand, _super);
    function CreateStoreImageTaskCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateStoreImageTaskCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateStoreImageTaskCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateStoreImageTaskRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateStoreImageTaskResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateStoreImageTaskCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateStoreImageTaskCommand(input, context);
    };
    CreateStoreImageTaskCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateStoreImageTaskCommand(output, context);
    };
    return CreateStoreImageTaskCommand;
}($Command));
export { CreateStoreImageTaskCommand };
