import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateRouteTableRequest, CreateRouteTableResult } from "../models/models_1";
import { deserializeAws_ec2CreateRouteTableCommand, serializeAws_ec2CreateRouteTableCommand, } from "../protocols/Aws_ec2";
var CreateRouteTableCommand = (function (_super) {
    __extends(CreateRouteTableCommand, _super);
    function CreateRouteTableCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateRouteTableCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateRouteTableCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateRouteTableRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateRouteTableResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateRouteTableCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateRouteTableCommand(input, context);
    };
    CreateRouteTableCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateRouteTableCommand(output, context);
    };
    return CreateRouteTableCommand;
}($Command));
export { CreateRouteTableCommand };
