import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateRestoreImageTaskRequest, CreateRestoreImageTaskResult } from "../models/models_1";
import { deserializeAws_ec2CreateRestoreImageTaskCommand, serializeAws_ec2CreateRestoreImageTaskCommand, } from "../protocols/Aws_ec2";
var CreateRestoreImageTaskCommand = (function (_super) {
    __extends(CreateRestoreImageTaskCommand, _super);
    function CreateRestoreImageTaskCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateRestoreImageTaskCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateRestoreImageTaskCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateRestoreImageTaskRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateRestoreImageTaskResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateRestoreImageTaskCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateRestoreImageTaskCommand(input, context);
    };
    CreateRestoreImageTaskCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateRestoreImageTaskCommand(output, context);
    };
    return CreateRestoreImageTaskCommand;
}($Command));
export { CreateRestoreImageTaskCommand };
