import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreatePlacementGroupRequest, CreatePlacementGroupResult } from "../models/models_1";
import { deserializeAws_ec2CreatePlacementGroupCommand, serializeAws_ec2CreatePlacementGroupCommand, } from "../protocols/Aws_ec2";
var CreatePlacementGroupCommand = (function (_super) {
    __extends(CreatePlacementGroupCommand, _super);
    function CreatePlacementGroupCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreatePlacementGroupCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreatePlacementGroupCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreatePlacementGroupRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreatePlacementGroupResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreatePlacementGroupCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreatePlacementGroupCommand(input, context);
    };
    CreatePlacementGroupCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreatePlacementGroupCommand(output, context);
    };
    return CreatePlacementGroupCommand;
}($Command));
export { CreatePlacementGroupCommand };
