import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateNetworkInsightsPathRequest, CreateNetworkInsightsPathResult } from "../models/models_1";
import { deserializeAws_ec2CreateNetworkInsightsPathCommand, serializeAws_ec2CreateNetworkInsightsPathCommand, } from "../protocols/Aws_ec2";
var CreateNetworkInsightsPathCommand = (function (_super) {
    __extends(CreateNetworkInsightsPathCommand, _super);
    function CreateNetworkInsightsPathCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateNetworkInsightsPathCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateNetworkInsightsPathCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateNetworkInsightsPathRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateNetworkInsightsPathResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateNetworkInsightsPathCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateNetworkInsightsPathCommand(input, context);
    };
    CreateNetworkInsightsPathCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateNetworkInsightsPathCommand(output, context);
    };
    return CreateNetworkInsightsPathCommand;
}($Command));
export { CreateNetworkInsightsPathCommand };
