import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateNetworkAclRequest, CreateNetworkAclResult } from "../models/models_1";
import { deserializeAws_ec2CreateNetworkAclCommand, serializeAws_ec2CreateNetworkAclCommand, } from "../protocols/Aws_ec2";
var CreateNetworkAclCommand = (function (_super) {
    __extends(CreateNetworkAclCommand, _super);
    function CreateNetworkAclCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateNetworkAclCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateNetworkAclCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateNetworkAclRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateNetworkAclResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateNetworkAclCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateNetworkAclCommand(input, context);
    };
    CreateNetworkAclCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateNetworkAclCommand(output, context);
    };
    return CreateNetworkAclCommand;
}($Command));
export { CreateNetworkAclCommand };
