import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateManagedPrefixListRequest, CreateManagedPrefixListResult } from "../models/models_1";
import { deserializeAws_ec2CreateManagedPrefixListCommand, serializeAws_ec2CreateManagedPrefixListCommand, } from "../protocols/Aws_ec2";
var CreateManagedPrefixListCommand = (function (_super) {
    __extends(CreateManagedPrefixListCommand, _super);
    function CreateManagedPrefixListCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateManagedPrefixListCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateManagedPrefixListCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateManagedPrefixListRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateManagedPrefixListResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateManagedPrefixListCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateManagedPrefixListCommand(input, context);
    };
    CreateManagedPrefixListCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateManagedPrefixListCommand(output, context);
    };
    return CreateManagedPrefixListCommand;
}($Command));
export { CreateManagedPrefixListCommand };
