import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateLocalGatewayRouteTableVpcAssociationRequest, CreateLocalGatewayRouteTableVpcAssociationResult, } from "../models/models_1";
import { deserializeAws_ec2CreateLocalGatewayRouteTableVpcAssociationCommand, serializeAws_ec2CreateLocalGatewayRouteTableVpcAssociationCommand, } from "../protocols/Aws_ec2";
var CreateLocalGatewayRouteTableVpcAssociationCommand = (function (_super) {
    __extends(CreateLocalGatewayRouteTableVpcAssociationCommand, _super);
    function CreateLocalGatewayRouteTableVpcAssociationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateLocalGatewayRouteTableVpcAssociationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateLocalGatewayRouteTableVpcAssociationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateLocalGatewayRouteTableVpcAssociationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateLocalGatewayRouteTableVpcAssociationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateLocalGatewayRouteTableVpcAssociationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateLocalGatewayRouteTableVpcAssociationCommand(input, context);
    };
    CreateLocalGatewayRouteTableVpcAssociationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateLocalGatewayRouteTableVpcAssociationCommand(output, context);
    };
    return CreateLocalGatewayRouteTableVpcAssociationCommand;
}($Command));
export { CreateLocalGatewayRouteTableVpcAssociationCommand };
