import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateLaunchTemplateRequest, CreateLaunchTemplateResult } from "../models/models_1";
import { deserializeAws_ec2CreateLaunchTemplateCommand, serializeAws_ec2CreateLaunchTemplateCommand, } from "../protocols/Aws_ec2";
var CreateLaunchTemplateCommand = (function (_super) {
    __extends(CreateLaunchTemplateCommand, _super);
    function CreateLaunchTemplateCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateLaunchTemplateCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateLaunchTemplateCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateLaunchTemplateRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateLaunchTemplateResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateLaunchTemplateCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateLaunchTemplateCommand(input, context);
    };
    CreateLaunchTemplateCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateLaunchTemplateCommand(output, context);
    };
    return CreateLaunchTemplateCommand;
}($Command));
export { CreateLaunchTemplateCommand };
