import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateIpamScopeRequest, CreateIpamScopeResult } from "../models/models_1";
import { deserializeAws_ec2CreateIpamScopeCommand, serializeAws_ec2CreateIpamScopeCommand } from "../protocols/Aws_ec2";
var CreateIpamScopeCommand = (function (_super) {
    __extends(CreateIpamScopeCommand, _super);
    function CreateIpamScopeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateIpamScopeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateIpamScopeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateIpamScopeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateIpamScopeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateIpamScopeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateIpamScopeCommand(input, context);
    };
    CreateIpamScopeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateIpamScopeCommand(output, context);
    };
    return CreateIpamScopeCommand;
}($Command));
export { CreateIpamScopeCommand };
