import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateInstanceEventWindowRequest, CreateInstanceEventWindowResult } from "../models/models_1";
import { deserializeAws_ec2CreateInstanceEventWindowCommand, serializeAws_ec2CreateInstanceEventWindowCommand, } from "../protocols/Aws_ec2";
var CreateInstanceEventWindowCommand = (function (_super) {
    __extends(CreateInstanceEventWindowCommand, _super);
    function CreateInstanceEventWindowCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateInstanceEventWindowCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateInstanceEventWindowCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateInstanceEventWindowRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateInstanceEventWindowResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateInstanceEventWindowCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateInstanceEventWindowCommand(input, context);
    };
    CreateInstanceEventWindowCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateInstanceEventWindowCommand(output, context);
    };
    return CreateInstanceEventWindowCommand;
}($Command));
export { CreateInstanceEventWindowCommand };
