import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateFpgaImageRequest, CreateFpgaImageResult } from "../models/models_1";
import { deserializeAws_ec2CreateFpgaImageCommand, serializeAws_ec2CreateFpgaImageCommand } from "../protocols/Aws_ec2";
var CreateFpgaImageCommand = (function (_super) {
    __extends(CreateFpgaImageCommand, _super);
    function CreateFpgaImageCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateFpgaImageCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateFpgaImageCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateFpgaImageRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateFpgaImageResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateFpgaImageCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateFpgaImageCommand(input, context);
    };
    CreateFpgaImageCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateFpgaImageCommand(output, context);
    };
    return CreateFpgaImageCommand;
}($Command));
export { CreateFpgaImageCommand };
