import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateCustomerGatewayRequest, CreateCustomerGatewayResult } from "../models/models_0";
import { deserializeAws_ec2CreateCustomerGatewayCommand, serializeAws_ec2CreateCustomerGatewayCommand, } from "../protocols/Aws_ec2";
var CreateCustomerGatewayCommand = (function (_super) {
    __extends(CreateCustomerGatewayCommand, _super);
    function CreateCustomerGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateCustomerGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateCustomerGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateCustomerGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateCustomerGatewayResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateCustomerGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateCustomerGatewayCommand(input, context);
    };
    CreateCustomerGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateCustomerGatewayCommand(output, context);
    };
    return CreateCustomerGatewayCommand;
}($Command));
export { CreateCustomerGatewayCommand };
