import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateCarrierGatewayRequest, CreateCarrierGatewayResult } from "../models/models_0";
import { deserializeAws_ec2CreateCarrierGatewayCommand, serializeAws_ec2CreateCarrierGatewayCommand, } from "../protocols/Aws_ec2";
var CreateCarrierGatewayCommand = (function (_super) {
    __extends(CreateCarrierGatewayCommand, _super);
    function CreateCarrierGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateCarrierGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateCarrierGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateCarrierGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateCarrierGatewayResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateCarrierGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateCarrierGatewayCommand(input, context);
    };
    CreateCarrierGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateCarrierGatewayCommand(output, context);
    };
    return CreateCarrierGatewayCommand;
}($Command));
export { CreateCarrierGatewayCommand };
