import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CopyImageRequest, CopyImageResult } from "../models/models_0";
import { deserializeAws_ec2CopyImageCommand, serializeAws_ec2CopyImageCommand } from "../protocols/Aws_ec2";
var CopyImageCommand = (function (_super) {
    __extends(CopyImageCommand, _super);
    function CopyImageCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CopyImageCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CopyImageCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CopyImageRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CopyImageResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CopyImageCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CopyImageCommand(input, context);
    };
    CopyImageCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CopyImageCommand(output, context);
    };
    return CopyImageCommand;
}($Command));
export { CopyImageCommand };
