import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CancelSpotFleetRequestsRequest, CancelSpotFleetRequestsResponse } from "../models/models_0";
import { deserializeAws_ec2CancelSpotFleetRequestsCommand, serializeAws_ec2CancelSpotFleetRequestsCommand, } from "../protocols/Aws_ec2";
var CancelSpotFleetRequestsCommand = (function (_super) {
    __extends(CancelSpotFleetRequestsCommand, _super);
    function CancelSpotFleetRequestsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CancelSpotFleetRequestsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CancelSpotFleetRequestsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CancelSpotFleetRequestsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CancelSpotFleetRequestsResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CancelSpotFleetRequestsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CancelSpotFleetRequestsCommand(input, context);
    };
    CancelSpotFleetRequestsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CancelSpotFleetRequestsCommand(output, context);
    };
    return CancelSpotFleetRequestsCommand;
}($Command));
export { CancelSpotFleetRequestsCommand };
