import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CancelImportTaskRequest, CancelImportTaskResult } from "../models/models_0";
import { deserializeAws_ec2CancelImportTaskCommand, serializeAws_ec2CancelImportTaskCommand, } from "../protocols/Aws_ec2";
var CancelImportTaskCommand = (function (_super) {
    __extends(CancelImportTaskCommand, _super);
    function CancelImportTaskCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CancelImportTaskCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CancelImportTaskCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CancelImportTaskRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CancelImportTaskResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CancelImportTaskCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CancelImportTaskCommand(input, context);
    };
    CancelImportTaskCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CancelImportTaskCommand(output, context);
    };
    return CancelImportTaskCommand;
}($Command));
export { CancelImportTaskCommand };
