import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CancelCapacityReservationRequest, CancelCapacityReservationResult } from "../models/models_0";
import { deserializeAws_ec2CancelCapacityReservationCommand, serializeAws_ec2CancelCapacityReservationCommand, } from "../protocols/Aws_ec2";
var CancelCapacityReservationCommand = (function (_super) {
    __extends(CancelCapacityReservationCommand, _super);
    function CancelCapacityReservationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CancelCapacityReservationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CancelCapacityReservationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CancelCapacityReservationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CancelCapacityReservationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CancelCapacityReservationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CancelCapacityReservationCommand(input, context);
    };
    CancelCapacityReservationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CancelCapacityReservationCommand(output, context);
    };
    return CancelCapacityReservationCommand;
}($Command));
export { CancelCapacityReservationCommand };
