import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CancelBundleTaskRequest, CancelBundleTaskResult } from "../models/models_0";
import { deserializeAws_ec2CancelBundleTaskCommand, serializeAws_ec2CancelBundleTaskCommand, } from "../protocols/Aws_ec2";
var CancelBundleTaskCommand = (function (_super) {
    __extends(CancelBundleTaskCommand, _super);
    function CancelBundleTaskCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CancelBundleTaskCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CancelBundleTaskCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CancelBundleTaskRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CancelBundleTaskResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CancelBundleTaskCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CancelBundleTaskCommand(input, context);
    };
    CancelBundleTaskCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CancelBundleTaskCommand(output, context);
    };
    return CancelBundleTaskCommand;
}($Command));
export { CancelBundleTaskCommand };
