import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AuthorizeSecurityGroupEgressRequest, AuthorizeSecurityGroupEgressResult } from "../models/models_0";
import { deserializeAws_ec2AuthorizeSecurityGroupEgressCommand, serializeAws_ec2AuthorizeSecurityGroupEgressCommand, } from "../protocols/Aws_ec2";
var AuthorizeSecurityGroupEgressCommand = (function (_super) {
    __extends(AuthorizeSecurityGroupEgressCommand, _super);
    function AuthorizeSecurityGroupEgressCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AuthorizeSecurityGroupEgressCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AuthorizeSecurityGroupEgressCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AuthorizeSecurityGroupEgressRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AuthorizeSecurityGroupEgressResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AuthorizeSecurityGroupEgressCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AuthorizeSecurityGroupEgressCommand(input, context);
    };
    AuthorizeSecurityGroupEgressCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AuthorizeSecurityGroupEgressCommand(output, context);
    };
    return AuthorizeSecurityGroupEgressCommand;
}($Command));
export { AuthorizeSecurityGroupEgressCommand };
