import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AttachVpnGatewayRequest, AttachVpnGatewayResult } from "../models/models_0";
import { deserializeAws_ec2AttachVpnGatewayCommand, serializeAws_ec2AttachVpnGatewayCommand, } from "../protocols/Aws_ec2";
var AttachVpnGatewayCommand = (function (_super) {
    __extends(AttachVpnGatewayCommand, _super);
    function AttachVpnGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AttachVpnGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AttachVpnGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AttachVpnGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AttachVpnGatewayResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AttachVpnGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AttachVpnGatewayCommand(input, context);
    };
    AttachVpnGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AttachVpnGatewayCommand(output, context);
    };
    return AttachVpnGatewayCommand;
}($Command));
export { AttachVpnGatewayCommand };
