import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssociateVpcCidrBlockRequest, AssociateVpcCidrBlockResult } from "../models/models_0";
import { deserializeAws_ec2AssociateVpcCidrBlockCommand, serializeAws_ec2AssociateVpcCidrBlockCommand, } from "../protocols/Aws_ec2";
var AssociateVpcCidrBlockCommand = (function (_super) {
    __extends(AssociateVpcCidrBlockCommand, _super);
    function AssociateVpcCidrBlockCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AssociateVpcCidrBlockCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AssociateVpcCidrBlockCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AssociateVpcCidrBlockRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AssociateVpcCidrBlockResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AssociateVpcCidrBlockCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AssociateVpcCidrBlockCommand(input, context);
    };
    AssociateVpcCidrBlockCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AssociateVpcCidrBlockCommand(output, context);
    };
    return AssociateVpcCidrBlockCommand;
}($Command));
export { AssociateVpcCidrBlockCommand };
