import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssociateTransitGatewayMulticastDomainRequest, AssociateTransitGatewayMulticastDomainResult, } from "../models/models_0";
import { deserializeAws_ec2AssociateTransitGatewayMulticastDomainCommand, serializeAws_ec2AssociateTransitGatewayMulticastDomainCommand, } from "../protocols/Aws_ec2";
var AssociateTransitGatewayMulticastDomainCommand = (function (_super) {
    __extends(AssociateTransitGatewayMulticastDomainCommand, _super);
    function AssociateTransitGatewayMulticastDomainCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AssociateTransitGatewayMulticastDomainCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AssociateTransitGatewayMulticastDomainCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AssociateTransitGatewayMulticastDomainRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AssociateTransitGatewayMulticastDomainResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AssociateTransitGatewayMulticastDomainCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AssociateTransitGatewayMulticastDomainCommand(input, context);
    };
    AssociateTransitGatewayMulticastDomainCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AssociateTransitGatewayMulticastDomainCommand(output, context);
    };
    return AssociateTransitGatewayMulticastDomainCommand;
}($Command));
export { AssociateTransitGatewayMulticastDomainCommand };
