import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssociateIamInstanceProfileRequest, AssociateIamInstanceProfileResult } from "../models/models_0";
import { deserializeAws_ec2AssociateIamInstanceProfileCommand, serializeAws_ec2AssociateIamInstanceProfileCommand, } from "../protocols/Aws_ec2";
var AssociateIamInstanceProfileCommand = (function (_super) {
    __extends(AssociateIamInstanceProfileCommand, _super);
    function AssociateIamInstanceProfileCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AssociateIamInstanceProfileCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AssociateIamInstanceProfileCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AssociateIamInstanceProfileRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AssociateIamInstanceProfileResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AssociateIamInstanceProfileCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AssociateIamInstanceProfileCommand(input, context);
    };
    AssociateIamInstanceProfileCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AssociateIamInstanceProfileCommand(output, context);
    };
    return AssociateIamInstanceProfileCommand;
}($Command));
export { AssociateIamInstanceProfileCommand };
