import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssociateClientVpnTargetNetworkRequest, AssociateClientVpnTargetNetworkResult } from "../models/models_0";
import { deserializeAws_ec2AssociateClientVpnTargetNetworkCommand, serializeAws_ec2AssociateClientVpnTargetNetworkCommand, } from "../protocols/Aws_ec2";
var AssociateClientVpnTargetNetworkCommand = (function (_super) {
    __extends(AssociateClientVpnTargetNetworkCommand, _super);
    function AssociateClientVpnTargetNetworkCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AssociateClientVpnTargetNetworkCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AssociateClientVpnTargetNetworkCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AssociateClientVpnTargetNetworkRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AssociateClientVpnTargetNetworkResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AssociateClientVpnTargetNetworkCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AssociateClientVpnTargetNetworkCommand(input, context);
    };
    AssociateClientVpnTargetNetworkCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AssociateClientVpnTargetNetworkCommand(output, context);
    };
    return AssociateClientVpnTargetNetworkCommand;
}($Command));
export { AssociateClientVpnTargetNetworkCommand };
