import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssociateAddressRequest, AssociateAddressResult } from "../models/models_0";
import { deserializeAws_ec2AssociateAddressCommand, serializeAws_ec2AssociateAddressCommand, } from "../protocols/Aws_ec2";
var AssociateAddressCommand = (function (_super) {
    __extends(AssociateAddressCommand, _super);
    function AssociateAddressCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AssociateAddressCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AssociateAddressCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AssociateAddressRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AssociateAddressResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AssociateAddressCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AssociateAddressCommand(input, context);
    };
    AssociateAddressCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AssociateAddressCommand(output, context);
    };
    return AssociateAddressCommand;
}($Command));
export { AssociateAddressCommand };
