import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssignIpv6AddressesRequest, AssignIpv6AddressesResult } from "../models/models_0";
import { deserializeAws_ec2AssignIpv6AddressesCommand, serializeAws_ec2AssignIpv6AddressesCommand, } from "../protocols/Aws_ec2";
var AssignIpv6AddressesCommand = (function (_super) {
    __extends(AssignIpv6AddressesCommand, _super);
    function AssignIpv6AddressesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AssignIpv6AddressesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AssignIpv6AddressesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AssignIpv6AddressesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AssignIpv6AddressesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AssignIpv6AddressesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AssignIpv6AddressesCommand(input, context);
    };
    AssignIpv6AddressesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AssignIpv6AddressesCommand(output, context);
    };
    return AssignIpv6AddressesCommand;
}($Command));
export { AssignIpv6AddressesCommand };
