import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AdvertiseByoipCidrRequest, AdvertiseByoipCidrResult } from "../models/models_0";
import { deserializeAws_ec2AdvertiseByoipCidrCommand, serializeAws_ec2AdvertiseByoipCidrCommand, } from "../protocols/Aws_ec2";
var AdvertiseByoipCidrCommand = (function (_super) {
    __extends(AdvertiseByoipCidrCommand, _super);
    function AdvertiseByoipCidrCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AdvertiseByoipCidrCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AdvertiseByoipCidrCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AdvertiseByoipCidrRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AdvertiseByoipCidrResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AdvertiseByoipCidrCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AdvertiseByoipCidrCommand(input, context);
    };
    AdvertiseByoipCidrCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AdvertiseByoipCidrCommand(output, context);
    };
    return AdvertiseByoipCidrCommand;
}($Command));
export { AdvertiseByoipCidrCommand };
