import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AcceptTransitGatewayPeeringAttachmentRequest, AcceptTransitGatewayPeeringAttachmentResult, } from "../models/models_0";
import { deserializeAws_ec2AcceptTransitGatewayPeeringAttachmentCommand, serializeAws_ec2AcceptTransitGatewayPeeringAttachmentCommand, } from "../protocols/Aws_ec2";
var AcceptTransitGatewayPeeringAttachmentCommand = (function (_super) {
    __extends(AcceptTransitGatewayPeeringAttachmentCommand, _super);
    function AcceptTransitGatewayPeeringAttachmentCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AcceptTransitGatewayPeeringAttachmentCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AcceptTransitGatewayPeeringAttachmentCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AcceptTransitGatewayPeeringAttachmentRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AcceptTransitGatewayPeeringAttachmentResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AcceptTransitGatewayPeeringAttachmentCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AcceptTransitGatewayPeeringAttachmentCommand(input, context);
    };
    AcceptTransitGatewayPeeringAttachmentCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AcceptTransitGatewayPeeringAttachmentCommand(output, context);
    };
    return AcceptTransitGatewayPeeringAttachmentCommand;
}($Command));
export { AcceptTransitGatewayPeeringAttachmentCommand };
