import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AcceptTransitGatewayMulticastDomainAssociationsRequest, AcceptTransitGatewayMulticastDomainAssociationsResult, } from "../models/models_0";
import { deserializeAws_ec2AcceptTransitGatewayMulticastDomainAssociationsCommand, serializeAws_ec2AcceptTransitGatewayMulticastDomainAssociationsCommand, } from "../protocols/Aws_ec2";
var AcceptTransitGatewayMulticastDomainAssociationsCommand = (function (_super) {
    __extends(AcceptTransitGatewayMulticastDomainAssociationsCommand, _super);
    function AcceptTransitGatewayMulticastDomainAssociationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AcceptTransitGatewayMulticastDomainAssociationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AcceptTransitGatewayMulticastDomainAssociationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AcceptTransitGatewayMulticastDomainAssociationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AcceptTransitGatewayMulticastDomainAssociationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AcceptTransitGatewayMulticastDomainAssociationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AcceptTransitGatewayMulticastDomainAssociationsCommand(input, context);
    };
    AcceptTransitGatewayMulticastDomainAssociationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AcceptTransitGatewayMulticastDomainAssociationsCommand(output, context);
    };
    return AcceptTransitGatewayMulticastDomainAssociationsCommand;
}($Command));
export { AcceptTransitGatewayMulticastDomainAssociationsCommand };
