"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilSecurityGroupExists = exports.waitForSecurityGroupExists = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const DescribeSecurityGroupsCommand_1 = require("../commands/DescribeSecurityGroupsCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeSecurityGroupsCommand_1.DescribeSecurityGroupsCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.SecurityGroups);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.GroupId;
                });
                return projection_3.length > 0.0;
            };
            if (returnComparator() == true) {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "InvalidGroup.NotFound") {
            return { state: util_waiter_1.WaiterState.RETRY, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForSecurityGroupExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    return util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForSecurityGroupExists = waitForSecurityGroupExists;
const waitUntilSecurityGroupExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    const result = await util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return util_waiter_1.checkExceptions(result);
};
exports.waitUntilSecurityGroupExists = waitUntilSecurityGroupExists;
