"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilInstanceExists = exports.waitForInstanceExists = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const DescribeInstancesCommand_1 = require("../commands/DescribeInstancesCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeInstancesCommand_1.DescribeInstancesCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.Reservations);
                return flat_1.length > 0.0;
            };
            if (returnComparator() == true) {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "InvalidInstanceID.NotFound") {
            return { state: util_waiter_1.WaiterState.RETRY, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForInstanceExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    return util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForInstanceExists = waitForInstanceExists;
const waitUntilInstanceExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    const result = await util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return util_waiter_1.checkExceptions(result);
};
exports.waitUntilInstanceExists = waitUntilInstanceExists;
