"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateSearchTransitGatewayMulticastGroups = void 0;
const SearchTransitGatewayMulticastGroupsCommand_1 = require("../commands/SearchTransitGatewayMulticastGroupsCommand");
const EC2_1 = require("../EC2");
const EC2Client_1 = require("../EC2Client");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new SearchTransitGatewayMulticastGroupsCommand_1.SearchTransitGatewayMulticastGroupsCommand(input), ...args);
};
const makePagedRequest = async (client, input, ...args) => {
    return await client.searchTransitGatewayMulticastGroups(input, ...args);
};
async function* paginateSearchTransitGatewayMulticastGroups(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof EC2_1.EC2) {
            page = await makePagedRequest(config.client, input, ...additionalArguments);
        }
        else if (config.client instanceof EC2Client_1.EC2Client) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected EC2 | EC2Client");
        }
        yield page;
        token = page.NextToken;
        hasNext = !!token;
    }
    return undefined;
}
exports.paginateSearchTransitGatewayMulticastGroups = paginateSearchTransitGatewayMulticastGroups;
