"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateDescribeVolumes = void 0;
const DescribeVolumesCommand_1 = require("../commands/DescribeVolumesCommand");
const EC2_1 = require("../EC2");
const EC2Client_1 = require("../EC2Client");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new DescribeVolumesCommand_1.DescribeVolumesCommand(input), ...args);
};
const makePagedRequest = async (client, input, ...args) => {
    return await client.describeVolumes(input, ...args);
};
async function* paginateDescribeVolumes(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof EC2_1.EC2) {
            page = await makePagedRequest(config.client, input, ...additionalArguments);
        }
        else if (config.client instanceof EC2Client_1.EC2Client) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected EC2 | EC2Client");
        }
        yield page;
        token = page.NextToken;
        hasNext = !!token;
    }
    return undefined;
}
exports.paginateDescribeVolumes = paginateDescribeVolumes;
