"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const ec2Client = require("@aws-sdk/client-ec2");
async function handler(event, _context) {
    var _a;
    const instanceId = process.env.INSTANCE_ID;
    const region = process.env.REGION;
    console.log('Event Recieved', { event });
    if (undefined == instanceId || undefined == region) {
        console.log('Missing ID or Region:', instanceId, region);
        return {
            statusCode: 500,
            body: `Please provide both instance id and region: instanceID: ${instanceId}, region: ${region}`,
        };
    }
    let password = '';
    if (event.queryStringParameters) {
        password = (_a = event.queryStringParameters.password) !== null && _a !== void 0 ? _a : 'NO PASSWORD PROVIDED';
    }
    if ('weaseldorf' !== password) {
        return {
            statusCode: 403,
            body: 'Unathorized!',
        };
    }
    try {
        const client = new ec2Client.EC2Client({ region: region });
        const stopInstancesCommandInput = {
            InstanceIds: [
                instanceId,
            ],
        };
        const stopInstancesCommand = new ec2Client.StopInstancesCommand(stopInstancesCommandInput);
        const results = await client.send(stopInstancesCommand);
        console.log('Results: ', { results });
        return {
            statusCode: 200,
            body: results,
        };
    }
    catch (e) {
        console.log('ERROR!', e);
        return {
            statusCode: 500,
            body: e,
        };
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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