from typing import Any, TypeVar, Type, List, Optional, Iterable, Tuple


class Field:
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...

class CharField(Field): ...
class IntegerField(Field): ...
class DateField(Field): ...
class AutoField(Field): ...
class ForeignKeyField(Field): ...
class TimestampField(Field): ...
class DateTimeField(Field): ...

T = TypeVar('T', bound='Model')

class Model:
    def __init__(self, **kwargs: Any) -> None: ...
    @classmethod
    def create(cls, **kwargs: Any)-> T: ...
    def save(self, *args: Any, **kwargs: Any) -> None: ...
    @classmethod
    def get_or_none(cls: Type[T], *args: Any, **kwargs: Any) -> Optional[T]: ...
    def is_null(self) -> bool: ...
    def delete_instance(self, **kwargs: Any) -> None: ...
    @classmethod
    def bulk_update(cls, model_list: Iterable[T], fields: List[Any], batch_size: int) -> None: ...
    @classmethod
    def select(cls) -> Any: ...
    @classmethod
    def update(cls, **kwargs: Any) -> Any: ...

    @classmethod
    def raw(cls, sql: str, *args: Any) -> Iterable[T]:
        ...

class SqliteDatabase:
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def init(self, *args: Any) -> None: ...
    def connect(self)->None: ...
    def create_tables(self, tables: List[Any])->None: ...

class DoesNotExist(BaseException): ...
class IntegrityError(BaseException): ...


class sqlite3:
    sqlite_version_info: Tuple[int, int, int]
