from setuptools import setup

with open("README.md", 'r', encoding='utf-8') as r:
    long_description = r.read()

setup(
    name='gamesdb_api',
    version='0.3.1',
    description='Um pacote Python para extrair informações de jogos do site TheGamesDB.net.',
    long_description=long_description,
    long_description_content_type='text/markdown',
    author='Bruno Rodrigues',
    author_email='email@bruno.gs',
    license='MIT',
    project_urls={'GitHub': 'https://github.com/rc-bruno/gamesdb_api'},
    install_requires=[
        'attrs==22.2.0',
        'beautifulsoup4==4.11.2',
        'bleach==6.0.0',
        'certifi==2022.12.7',
        'charset-normalizer==3.0.1',
        'colorama==0.4.6',
        'coverage==7.1.0',
        'docutils==0.19',
        'exceptiongroup==1.1.0',
        'fuzzywuzzy==0.18.0',
        'idna==3.4',
        'importlib-metadata==6.0.0',
        'iniconfig==2.0.0',
        'jaraco.classes==3.2.3',
        'keyring==23.13.1',
        'Levenshtein==0.20.9',
        'markdown-it-py==2.1.0',
        'mdurl==0.1.2',
        'more-itertools==9.0.0',
        'packaging==23.0',
        'pkginfo==1.9.6',
        'pluggy==1.0.0',
        'Pygments==2.14.0',
        'pytest==7.2.1',
        'pytest-cov==4.0.0',
        'python-Levenshtein==0.20.9',
        'pywin32-ctypes==0.2.0',
        'rapidfuzz==2.13.7',
        'readme-renderer==37.3',
        'requests==2.28.2',
        'requests-toolbelt==0.10.1',
        'rfc3986==2.0.0',
        'rich==13.3.1',
        'six==1.16.0',
        'soupsieve==2.4',
        'tomli==2.0.1',
        'twine==4.0.2',
        'urllib3==1.26.14',
        'webencodings==0.5.1',
        'zipp==3.13.0']
    ,
    packages=['gamesdb_api'],
    classifiers=['Development Status :: 3 - Alpha', 'Intended Audience :: Developers',
                 'Natural Language :: Portuguese (Brazilian)',
                 'License :: OSI Approved :: MIT License', 'Programming Language :: Python :: 3',
                 'Programming Language :: Python :: 3.6', 'Programming Language :: Python :: 3.7',
                 'Programming Language :: Python :: 3.8', 'Programming Language :: Python :: 3.9',
                 'Topic :: Software Development :: Libraries', 'Topic :: Utilities']
)
