import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the profile.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/profile#description Profile#description}
    */
    readonly description?: string;
    /**
    * The name of the profile.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/profile#name Profile#name}
    */
    readonly name: string;
    /**
    * Map of permissions for the profile. At this time specific permissions can only be set, the comprehensive list will not be read from Salesforce. The keys should follow Salesforce 'SnakeCase' format however the 'Permissions' prefix should be omitted. Permissions will not import to state due to a technical limitation, you will need to run a subsequent apply if you have permissions set in config during import.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/profile#permissions Profile#permissions}
    */
    readonly permissions?: {
        [key: string]: (boolean | cdktf.IResolvable);
    };
    /**
    * ID of the UserLicense associated with this profile. Forces replacement if updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/profile#user_license_id Profile#user_license_id}
    */
    readonly userLicenseId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/salesforce/r/profile salesforce_profile}
*/
export declare class Profile extends cdktf.TerraformResource {
    static readonly tfResourceType = "salesforce_profile";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/salesforce/r/profile salesforce_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProfileConfig
    */
    constructor(scope: Construct, id: string, config: ProfileConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _permissions?;
    get permissions(): {
        [key: string]: (boolean | cdktf.IResolvable);
    };
    set permissions(value: {
        [key: string]: (boolean | cdktf.IResolvable);
    });
    resetPermissions(): void;
    get permissionsInput(): {
        [key: string]: boolean | cdktf.IResolvable;
    } | undefined;
    private _userLicenseId?;
    get userLicenseId(): string;
    set userLicenseId(value: string);
    get userLicenseIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
