# coding: utf-8

"""
    UniCatDB API

    UniCatDB application API documentation, with examples and live testing.  This API is built in accordance with the **JSON API 1.0 standard**. For general information, see [the documentation](http://jsonapi.org/format/).  **Notes:** * JSON API standard requires use of the JSON API media type (application/vnd.api+json) for exchanging data. Clients must send all JSON API data with the headers `Content-Type: application/vnd.api+json` (POST, PATCH) and `Accept: application/vnd.api+json` (GET, DELETE). * [Relationships](http://jsonapi.org/format/#fetching-relationships) and their [inclusions](http://jsonapi.org/format/#fetching-includes) via the `include` query parameter, as specified by the standard, **are not implemented**, since there are no relationships present in the data model. * The standard does not prescribe any filtering strategies. This API implements two strategies which can be combined: **Basic filtering** based on the used [JSON API library](https://json-api-dotnet.github.io/#/filtering) and **Custom filtering** which allow for any possible query to the MongoDB server and can be extended and customize in the future. For more information about filtering, see the description of the `filter` down bellow. * **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from unicatdb.openapi_client.configuration import Configuration


class StatisticalDataItem(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'group': 'str',
        'min': 'float',
        'max': 'float',
        'average': 'float',
        'stddevpopulation': 'float',
        'stddevsample': 'float',
        'sum': 'float',
        'count': 'int'
    }

    attribute_map = {
        'group': 'group',
        'min': 'min',
        'max': 'max',
        'average': 'average',
        'stddevpopulation': 'stddevpopulation',
        'stddevsample': 'stddevsample',
        'sum': 'sum',
        'count': 'count'
    }

    def __init__(self, group=None, min=None, max=None, average=None, stddevpopulation=None, stddevsample=None, sum=None, count=None, local_vars_configuration=None):  # noqa: E501
        """StatisticalDataItem - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._group = None
        self._min = None
        self._max = None
        self._average = None
        self._stddevpopulation = None
        self._stddevsample = None
        self._sum = None
        self._count = None
        self.discriminator = None

        self.group = group
        self.min = min
        self.max = max
        self.average = average
        self.stddevpopulation = stddevpopulation
        self.stddevsample = stddevsample
        self.sum = sum
        self.count = count

    @property
    def group(self):
        """Gets the group of this StatisticalDataItem.  # noqa: E501


        :return: The group of this StatisticalDataItem.  # noqa: E501
        :rtype: str
        """
        return self._group

    @group.setter
    def group(self, group):
        """Sets the group of this StatisticalDataItem.


        :param group: The group of this StatisticalDataItem.  # noqa: E501
        :type group: str
        """

        self._group = group

    @property
    def min(self):
        """Gets the min of this StatisticalDataItem.  # noqa: E501


        :return: The min of this StatisticalDataItem.  # noqa: E501
        :rtype: float
        """
        return self._min

    @min.setter
    def min(self, min):
        """Sets the min of this StatisticalDataItem.


        :param min: The min of this StatisticalDataItem.  # noqa: E501
        :type min: float
        """
        if self.local_vars_configuration.client_side_validation and min is None:  # noqa: E501
            raise ValueError("Invalid value for `min`, must not be `None`")  # noqa: E501

        self._min = min

    @property
    def max(self):
        """Gets the max of this StatisticalDataItem.  # noqa: E501


        :return: The max of this StatisticalDataItem.  # noqa: E501
        :rtype: float
        """
        return self._max

    @max.setter
    def max(self, max):
        """Sets the max of this StatisticalDataItem.


        :param max: The max of this StatisticalDataItem.  # noqa: E501
        :type max: float
        """
        if self.local_vars_configuration.client_side_validation and max is None:  # noqa: E501
            raise ValueError("Invalid value for `max`, must not be `None`")  # noqa: E501

        self._max = max

    @property
    def average(self):
        """Gets the average of this StatisticalDataItem.  # noqa: E501


        :return: The average of this StatisticalDataItem.  # noqa: E501
        :rtype: float
        """
        return self._average

    @average.setter
    def average(self, average):
        """Sets the average of this StatisticalDataItem.


        :param average: The average of this StatisticalDataItem.  # noqa: E501
        :type average: float
        """
        if self.local_vars_configuration.client_side_validation and average is None:  # noqa: E501
            raise ValueError("Invalid value for `average`, must not be `None`")  # noqa: E501

        self._average = average

    @property
    def stddevpopulation(self):
        """Gets the stddevpopulation of this StatisticalDataItem.  # noqa: E501


        :return: The stddevpopulation of this StatisticalDataItem.  # noqa: E501
        :rtype: float
        """
        return self._stddevpopulation

    @stddevpopulation.setter
    def stddevpopulation(self, stddevpopulation):
        """Sets the stddevpopulation of this StatisticalDataItem.


        :param stddevpopulation: The stddevpopulation of this StatisticalDataItem.  # noqa: E501
        :type stddevpopulation: float
        """
        if self.local_vars_configuration.client_side_validation and stddevpopulation is None:  # noqa: E501
            raise ValueError("Invalid value for `stddevpopulation`, must not be `None`")  # noqa: E501

        self._stddevpopulation = stddevpopulation

    @property
    def stddevsample(self):
        """Gets the stddevsample of this StatisticalDataItem.  # noqa: E501


        :return: The stddevsample of this StatisticalDataItem.  # noqa: E501
        :rtype: float
        """
        return self._stddevsample

    @stddevsample.setter
    def stddevsample(self, stddevsample):
        """Sets the stddevsample of this StatisticalDataItem.


        :param stddevsample: The stddevsample of this StatisticalDataItem.  # noqa: E501
        :type stddevsample: float
        """
        if self.local_vars_configuration.client_side_validation and stddevsample is None:  # noqa: E501
            raise ValueError("Invalid value for `stddevsample`, must not be `None`")  # noqa: E501

        self._stddevsample = stddevsample

    @property
    def sum(self):
        """Gets the sum of this StatisticalDataItem.  # noqa: E501


        :return: The sum of this StatisticalDataItem.  # noqa: E501
        :rtype: float
        """
        return self._sum

    @sum.setter
    def sum(self, sum):
        """Sets the sum of this StatisticalDataItem.


        :param sum: The sum of this StatisticalDataItem.  # noqa: E501
        :type sum: float
        """
        if self.local_vars_configuration.client_side_validation and sum is None:  # noqa: E501
            raise ValueError("Invalid value for `sum`, must not be `None`")  # noqa: E501

        self._sum = sum

    @property
    def count(self):
        """Gets the count of this StatisticalDataItem.  # noqa: E501


        :return: The count of this StatisticalDataItem.  # noqa: E501
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """Sets the count of this StatisticalDataItem.


        :param count: The count of this StatisticalDataItem.  # noqa: E501
        :type count: int
        """
        if self.local_vars_configuration.client_side_validation and count is None:  # noqa: E501
            raise ValueError("Invalid value for `count`, must not be `None`")  # noqa: E501

        self._count = count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StatisticalDataItem):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StatisticalDataItem):
            return True

        return self.to_dict() != other.to_dict()
