# coding: utf-8

"""
    UniCatDB API

    UniCatDB application API documentation, with examples and live testing.  This API is built in accordance with the **JSON API 1.0 standard**. For general information, see [the documentation](http://jsonapi.org/format/).  **Notes:** * JSON API standard requires use of the JSON API media type (application/vnd.api+json) for exchanging data. Clients must send all JSON API data with the headers `Content-Type: application/vnd.api+json` (POST, PATCH) and `Accept: application/vnd.api+json` (GET, DELETE). * [Relationships](http://jsonapi.org/format/#fetching-relationships) and their [inclusions](http://jsonapi.org/format/#fetching-includes) via the `include` query parameter, as specified by the standard, **are not implemented**, since there are no relationships present in the data model. * The standard does not prescribe any filtering strategies. This API implements two strategies which can be combined: **Basic filtering** based on the used [JSON API library](https://json-api-dotnet.github.io/#/filtering) and **Custom filtering** which allow for any possible query to the MongoDB server and can be extended and customize in the future. For more information about filtering, see the description of the `filter` down bellow. * **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from unicatdb.openapi_client.configuration import Configuration


class FindingSchemaElement(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'subtype': 'str',
        'required': 'bool',
        'label': 'str',
        'description': 'str',
        'placeholder': 'str',
        'name': 'str',
        'other': 'bool',
        'multiple': 'bool',
        'values': 'list[FindingSchemaElementValue]',
        'min': 'str',
        'max': 'str',
        'step': 'str',
        'maxlength': 'str',
        'class_name': 'str'
    }

    attribute_map = {
        'type': 'type',
        'subtype': 'subtype',
        'required': 'required',
        'label': 'label',
        'description': 'description',
        'placeholder': 'placeholder',
        'name': 'name',
        'other': 'other',
        'multiple': 'multiple',
        'values': 'values',
        'min': 'min',
        'max': 'max',
        'step': 'step',
        'maxlength': 'maxlength',
        'class_name': 'className'
    }

    def __init__(self, type=None, subtype=None, required=None, label=None, description=None, placeholder=None, name=None, other=None, multiple=None, values=None, min=None, max=None, step=None, maxlength=None, class_name=None, local_vars_configuration=None):  # noqa: E501
        """FindingSchemaElement - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._subtype = None
        self._required = None
        self._label = None
        self._description = None
        self._placeholder = None
        self._name = None
        self._other = None
        self._multiple = None
        self._values = None
        self._min = None
        self._max = None
        self._step = None
        self._maxlength = None
        self._class_name = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if subtype is not None:
            self.subtype = subtype
        if required is not None:
            self.required = required
        if label is not None:
            self.label = label
        if description is not None:
            self.description = description
        if placeholder is not None:
            self.placeholder = placeholder
        if name is not None:
            self.name = name
        if other is not None:
            self.other = other
        if multiple is not None:
            self.multiple = multiple
        if values is not None:
            self.values = values
        if min is not None:
            self.min = min
        if max is not None:
            self.max = max
        if step is not None:
            self.step = step
        if maxlength is not None:
            self.maxlength = maxlength
        if class_name is not None:
            self.class_name = class_name

    @property
    def type(self):
        """Gets the type of this FindingSchemaElement.  # noqa: E501


        :return: The type of this FindingSchemaElement.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this FindingSchemaElement.


        :param type: The type of this FindingSchemaElement.  # noqa: E501
        :type type: str
        """

        self._type = type

    @property
    def subtype(self):
        """Gets the subtype of this FindingSchemaElement.  # noqa: E501


        :return: The subtype of this FindingSchemaElement.  # noqa: E501
        :rtype: str
        """
        return self._subtype

    @subtype.setter
    def subtype(self, subtype):
        """Sets the subtype of this FindingSchemaElement.


        :param subtype: The subtype of this FindingSchemaElement.  # noqa: E501
        :type subtype: str
        """

        self._subtype = subtype

    @property
    def required(self):
        """Gets the required of this FindingSchemaElement.  # noqa: E501


        :return: The required of this FindingSchemaElement.  # noqa: E501
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """Sets the required of this FindingSchemaElement.


        :param required: The required of this FindingSchemaElement.  # noqa: E501
        :type required: bool
        """

        self._required = required

    @property
    def label(self):
        """Gets the label of this FindingSchemaElement.  # noqa: E501


        :return: The label of this FindingSchemaElement.  # noqa: E501
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this FindingSchemaElement.


        :param label: The label of this FindingSchemaElement.  # noqa: E501
        :type label: str
        """

        self._label = label

    @property
    def description(self):
        """Gets the description of this FindingSchemaElement.  # noqa: E501


        :return: The description of this FindingSchemaElement.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this FindingSchemaElement.


        :param description: The description of this FindingSchemaElement.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def placeholder(self):
        """Gets the placeholder of this FindingSchemaElement.  # noqa: E501


        :return: The placeholder of this FindingSchemaElement.  # noqa: E501
        :rtype: str
        """
        return self._placeholder

    @placeholder.setter
    def placeholder(self, placeholder):
        """Sets the placeholder of this FindingSchemaElement.


        :param placeholder: The placeholder of this FindingSchemaElement.  # noqa: E501
        :type placeholder: str
        """

        self._placeholder = placeholder

    @property
    def name(self):
        """Gets the name of this FindingSchemaElement.  # noqa: E501


        :return: The name of this FindingSchemaElement.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this FindingSchemaElement.


        :param name: The name of this FindingSchemaElement.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def other(self):
        """Gets the other of this FindingSchemaElement.  # noqa: E501


        :return: The other of this FindingSchemaElement.  # noqa: E501
        :rtype: bool
        """
        return self._other

    @other.setter
    def other(self, other):
        """Sets the other of this FindingSchemaElement.


        :param other: The other of this FindingSchemaElement.  # noqa: E501
        :type other: bool
        """

        self._other = other

    @property
    def multiple(self):
        """Gets the multiple of this FindingSchemaElement.  # noqa: E501


        :return: The multiple of this FindingSchemaElement.  # noqa: E501
        :rtype: bool
        """
        return self._multiple

    @multiple.setter
    def multiple(self, multiple):
        """Sets the multiple of this FindingSchemaElement.


        :param multiple: The multiple of this FindingSchemaElement.  # noqa: E501
        :type multiple: bool
        """

        self._multiple = multiple

    @property
    def values(self):
        """Gets the values of this FindingSchemaElement.  # noqa: E501


        :return: The values of this FindingSchemaElement.  # noqa: E501
        :rtype: list[FindingSchemaElementValue]
        """
        return self._values

    @values.setter
    def values(self, values):
        """Sets the values of this FindingSchemaElement.


        :param values: The values of this FindingSchemaElement.  # noqa: E501
        :type values: list[FindingSchemaElementValue]
        """

        self._values = values

    @property
    def min(self):
        """Gets the min of this FindingSchemaElement.  # noqa: E501


        :return: The min of this FindingSchemaElement.  # noqa: E501
        :rtype: str
        """
        return self._min

    @min.setter
    def min(self, min):
        """Sets the min of this FindingSchemaElement.


        :param min: The min of this FindingSchemaElement.  # noqa: E501
        :type min: str
        """

        self._min = min

    @property
    def max(self):
        """Gets the max of this FindingSchemaElement.  # noqa: E501


        :return: The max of this FindingSchemaElement.  # noqa: E501
        :rtype: str
        """
        return self._max

    @max.setter
    def max(self, max):
        """Sets the max of this FindingSchemaElement.


        :param max: The max of this FindingSchemaElement.  # noqa: E501
        :type max: str
        """

        self._max = max

    @property
    def step(self):
        """Gets the step of this FindingSchemaElement.  # noqa: E501


        :return: The step of this FindingSchemaElement.  # noqa: E501
        :rtype: str
        """
        return self._step

    @step.setter
    def step(self, step):
        """Sets the step of this FindingSchemaElement.


        :param step: The step of this FindingSchemaElement.  # noqa: E501
        :type step: str
        """

        self._step = step

    @property
    def maxlength(self):
        """Gets the maxlength of this FindingSchemaElement.  # noqa: E501


        :return: The maxlength of this FindingSchemaElement.  # noqa: E501
        :rtype: str
        """
        return self._maxlength

    @maxlength.setter
    def maxlength(self, maxlength):
        """Sets the maxlength of this FindingSchemaElement.


        :param maxlength: The maxlength of this FindingSchemaElement.  # noqa: E501
        :type maxlength: str
        """

        self._maxlength = maxlength

    @property
    def class_name(self):
        """Gets the class_name of this FindingSchemaElement.  # noqa: E501


        :return: The class_name of this FindingSchemaElement.  # noqa: E501
        :rtype: str
        """
        return self._class_name

    @class_name.setter
    def class_name(self, class_name):
        """Sets the class_name of this FindingSchemaElement.


        :param class_name: The class_name of this FindingSchemaElement.  # noqa: E501
        :type class_name: str
        """

        self._class_name = class_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FindingSchemaElement):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FindingSchemaElement):
            return True

        return self.to_dict() != other.to_dict()
